/*===========================================================================*\
 *                                                                           *
 *  ACG Tracker from the ECCV'14 Paper                                       *
 *  Scalable 6-DOF Localization on Mobile Devices                            *
 *  Copyright (C) 2014 by Computer Graphics Group, RWTH Aachen               *
 *  Author: Sven Middelberg <middelberg@cs.rwth-aachen.de>                   *
 *  www.rwth.graphics                                                        *
 *                                                                           *
 *---------------------------------------------------------------------------*
 *  This file is part of ACG Tracker                                         *
 *                                                                           *
 *  ACG Tracker is free software: you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation, either version 3 of the License, or        *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  ACG Tracker is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public License        *
 *  along with ACG Tracker. If not, see <http://www.gnu.org/licenses/>.      *
 *                                                                           *
\*===========================================================================*/

#include "AGASTDetection5_8.h"

namespace ACGT
{
    AGASTDetection5_8::AGASTDetection5_8() : _threshold(40) {};
    
    AGASTDetection5_8::AGASTDetection5_8(GrayscaleImage& image, const uint8_t& threshold) : _threshold(threshold)
    {
        setImage(image);
    }
    
    void AGASTDetection5_8::setImage(GrayscaleImage& image)
    {
        _image = GrayscaleImage(image[0], image.width(), image.height());
        
        _offset0 = (-1)+(0)*image.width();
        _offset1 = (-1)+(-1)*image.width();
        _offset2 = (0)+(-1)*image.width();
        _offset3 = (1)+(-1)*image.width();
        _offset4 = (1)+(0)*image.width();
        _offset5 = (1)+(1)*image.width();
        _offset6 = (0)+(1)*image.width();
        _offset7 = (-1)+(1)*image.width();
    }
    
    uint8_t& AGASTDetection5_8::threshold()
    {
        return _threshold;
    }
    
    const uint8_t& AGASTDetection5_8::threshold() const
    {
        return _threshold;
    }
    
    std::vector<Feature> AGASTDetection5_8::detect()
    {
        return detect(ImageRect(0, 0, _image.width(), _image.height()));
    }
    
    std::vector<Feature> AGASTDetection5_8::detect(const ImageRect& rect)
    {
        std::vector<Feature> features;
        
        int oX = rect.origin().x();
        int oY = rect.origin().y();
        unsigned int rectWidth = rect.width();
        unsigned int rectHeight = rect.height();
        
        // clip rect to valid area
        if (oX < 1)
        {
            rectWidth -= 1-oX;
            oX = 1;
        }
        
        if (oX >= _image.width()-1)
            return features;
        
        if (oY < 1)
        {
            rectHeight -= 1-oY;
            oY = 1;
        }
        
        if (oY >= _image.height()-1)
            return features;
        
        if (oX+rectWidth >= _image.width()-1)
            rectWidth -= oX+rectWidth-_image.width()+2;
        
        if (oY+rectHeight >= _image.height()-1)
            rectHeight -= oY+rectHeight-_image.height()+2;
        
        int x, y;
        int xMax=oX+rectWidth;
        int yMax=oY+rectHeight;
        const int numSkipPixels = _image.width()-rectWidth;
        
        const uint8_t *p = _image[0] + (oY * _image.width() + oX); // leave out the first 2 lines, then leave out the first 2 pixels
        int threshold_top, threshold_bottom;
        
        for(y=oY; y < yMax; y++)
        {
            x=oX-1;
            while (1)
            {
            homogeneous:
                {
                    x++;
                    if(x>xMax)
                    {
                        p += numSkipPixels; // leave out pixels not in Rect
                        break;
                    }
                    
                    ++p;
                    
                    threshold_top = *p + _threshold;
                    threshold_bottom = *p - _threshold;
                    
                    if(p[_offset0] > threshold_top)
                        if(p[_offset2] > threshold_top)
                            if(p[_offset3] > threshold_top)
                                if(p[_offset5] > threshold_top)
                                    if(p[_offset1] > threshold_top)
                                        if(p[_offset4] > threshold_top)
                                            goto success_structured;
                                        else
                                            if(p[_offset7] > threshold_top)
                                                goto success_structured;
                                            else
                                                goto homogeneous;
                                            else
                                                if(p[_offset4] > threshold_top)
                                                    if(p[_offset6] > threshold_top)
                                                        goto success_structured;
                                                    else
                                                        goto homogeneous;
                                                    else
                                                        goto homogeneous;
                                                    else
                                                        if(p[_offset1] > threshold_top)
                                                            if(p[_offset4] > threshold_top)
                                                                goto success_homogeneous;
                                                            else
                                                                if(p[_offset7] > threshold_top)
                                                                    goto success_homogeneous;
                                                                else
                                                                    goto homogeneous;
                                                                else
                                                                    goto homogeneous;
                                                                else
                                                                    if(p[_offset7] > threshold_top)
                                                                        if(p[_offset6] > threshold_top)
                                                                            if(p[_offset5] > threshold_top)
                                                                                if(p[_offset1] > threshold_top)
                                                                                    goto success_structured;
                                                                                else
                                                                                    if(p[_offset4] > threshold_top)
                                                                                        goto success_structured;
                                                                                    else
                                                                                        goto homogeneous;
                                                                                    else
                                                                                        if(p[_offset1] > threshold_top)
                                                                                            goto success_homogeneous;
                                                                                        else
                                                                                            goto homogeneous;
                                                                                        else
                                                                                            goto homogeneous;
                                                                                        else
                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                if(p[_offset3] < threshold_bottom)
                                                                                                    if(p[_offset7] < threshold_bottom)
                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                            if(p[_offset6] < threshold_bottom)
                                                                                                                goto success_structured;
                                                                                                            else
                                                                                                                goto structured;
                                                                                                            else
                                                                                                                goto homogeneous;
                                                                                                            else
                                                                                                                goto homogeneous;
                                                                                                            else
                                                                                                                goto homogeneous;
                                                                                                            else
                                                                                                                goto homogeneous;
                                                                                                            else
                                                                                                                if(p[_offset5] > threshold_top)
                                                                                                                    if(p[_offset7] > threshold_top)
                                                                                                                        if(p[_offset6] > threshold_top)
                                                                                                                            if(p[_offset1] > threshold_top)
                                                                                                                                goto success_homogeneous;
                                                                                                                            else
                                                                                                                                if(p[_offset4] > threshold_top)
                                                                                                                                    goto success_homogeneous;
                                                                                                                                else
                                                                                                                                    goto homogeneous;
                                                                                                                                else
                                                                                                                                    goto homogeneous;
                                                                                                                                else
                                                                                                                                    goto homogeneous;
                                                                                                                                else
                                                                                                                                    if(p[_offset5] < threshold_bottom)
                                                                                                                                        if(p[_offset3] < threshold_bottom)
                                                                                                                                            if(p[_offset2] < threshold_bottom)
                                                                                                                                                if(p[_offset1] < threshold_bottom)
                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                        goto success_structured;
                                                                                                                                                    else
                                                                                                                                                        goto homogeneous;
                                                                                                                                                    else
                                                                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                                                                            if(p[_offset6] < threshold_bottom)
                                                                                                                                                                goto success_structured;
                                                                                                                                                            else
                                                                                                                                                                goto homogeneous;
                                                                                                                                                            else
                                                                                                                                                                goto homogeneous;
                                                                                                                                                            else
                                                                                                                                                                if(p[_offset7] < threshold_bottom)
                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                            goto success_structured;
                                                                                                                                                                        else
                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                        else
                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                        else
                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                        else
                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                        else
                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                        else if(p[_offset0] < threshold_bottom)
                                                                                                                                                                            if(p[_offset2] < threshold_bottom)
                                                                                                                                                                                if(p[_offset7] > threshold_top)
                                                                                                                                                                                    if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                        if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                else
                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                else
                                                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                        else
                                                                                                                                                                                                            goto structured;
                                                                                                                                                                                                        else
                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                        else
                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                else
                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                else
                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                else
                                                                                                                                                                                                                    if(p[_offset5] > threshold_top)
                                                                                                                                                                                                                        if(p[_offset3] > threshold_top)
                                                                                                                                                                                                                            if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    if(p[_offset7] < threshold_bottom)
                                                                                                                                                                                                                                        if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                            goto structured;
                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                goto success_homogeneous;
                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                    if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                        if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                            if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                goto success_structured;
                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                    if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                                                                                                                        if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                    if(p[_offset5] > threshold_top)
                                                                                                                                                                                                                                                                                                                        if(p[_offset3] > threshold_top)
                                                                                                                                                                                                                                                                                                                            if(p[_offset2] > threshold_top)
                                                                                                                                                                                                                                                                                                                                if(p[_offset1] > threshold_top)
                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                        goto success_structured;
                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                            if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                goto success_structured;
                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                if(p[_offset7] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                        if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                if(p[_offset7] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset3] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset5] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset2] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset1] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset7] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                        goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset2] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset7] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                }
            structured:
                {
                    x++;
                    if(x>xMax)
                    {
                        p += numSkipPixels; // leave out pixels not in rect
                        break;
                    }
                    
                    ++p;
                    
                    threshold_top = *p + _threshold;
                    threshold_bottom = *p - _threshold;
                    
                    if(p[_offset0] > threshold_top)
                        if(p[_offset2] > threshold_top)
                            if(p[_offset3] > threshold_top)
                                if(p[_offset5] > threshold_top)
                                    if(p[_offset7] > threshold_top)
                                        if(p[_offset1] > threshold_top)
                                            goto success_structured;
                                        else
                                            if(p[_offset4] > threshold_top)
                                                if(p[_offset6] > threshold_top)
                                                    goto success_structured;
                                                else
                                                    goto structured;
                                                else
                                                    goto structured;
                                                else
                                                    if(p[_offset1] > threshold_top)
                                                        if(p[_offset4] > threshold_top)
                                                            goto success_structured;
                                                        else
                                                            goto structured;
                                                        else
                                                            if(p[_offset4] > threshold_top)
                                                                if(p[_offset6] > threshold_top)
                                                                    goto success_structured;
                                                                else
                                                                    goto structured;
                                                                else
                                                                    goto structured;
                                                                else
                                                                    if(p[_offset7] > threshold_top)
                                                                        if(p[_offset1] > threshold_top)
                                                                            goto success_structured;
                                                                        else
                                                                            goto structured;
                                                                        else
                                                                            if(p[_offset1] > threshold_top)
                                                                                if(p[_offset4] > threshold_top)
                                                                                    goto success_structured;
                                                                                else
                                                                                    goto structured;
                                                                                else
                                                                                    goto structured;
                                                                                else
                                                                                    if(p[_offset7] > threshold_top)
                                                                                        if(p[_offset6] > threshold_top)
                                                                                            if(p[_offset5] > threshold_top)
                                                                                                if(p[_offset1] > threshold_top)
                                                                                                    goto success_structured;
                                                                                                else
                                                                                                    if(p[_offset4] > threshold_top)
                                                                                                        goto success_structured;
                                                                                                    else
                                                                                                        goto structured;
                                                                                                    else
                                                                                                        if(p[_offset1] > threshold_top)
                                                                                                            goto success_structured;
                                                                                                        else
                                                                                                            goto structured;
                                                                                                        else
                                                                                                            goto structured;
                                                                                                        else
                                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                                if(p[_offset3] < threshold_bottom)
                                                                                                                    if(p[_offset7] < threshold_bottom)
                                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                                            if(p[_offset6] < threshold_bottom)
                                                                                                                                goto success_structured;
                                                                                                                            else
                                                                                                                                goto structured;
                                                                                                                            else
                                                                                                                                goto structured;
                                                                                                                            else
                                                                                                                                goto homogeneous;
                                                                                                                            else
                                                                                                                                goto homogeneous;
                                                                                                                            else
                                                                                                                                goto structured;
                                                                                                                            else
                                                                                                                                if(p[_offset5] > threshold_top)
                                                                                                                                    if(p[_offset7] > threshold_top)
                                                                                                                                        if(p[_offset6] > threshold_top)
                                                                                                                                            if(p[_offset1] > threshold_top)
                                                                                                                                                goto success_structured;
                                                                                                                                            else
                                                                                                                                                if(p[_offset4] > threshold_top)
                                                                                                                                                    goto success_structured;
                                                                                                                                                else
                                                                                                                                                    goto structured;
                                                                                                                                                else
                                                                                                                                                    goto structured;
                                                                                                                                                else
                                                                                                                                                    goto structured;
                                                                                                                                                else
                                                                                                                                                    if(p[_offset5] < threshold_bottom)
                                                                                                                                                        if(p[_offset3] < threshold_bottom)
                                                                                                                                                            if(p[_offset2] < threshold_bottom)
                                                                                                                                                                if(p[_offset1] < threshold_bottom)
                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                        goto success_structured;
                                                                                                                                                                    else
                                                                                                                                                                        goto structured;
                                                                                                                                                                    else
                                                                                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                                                                                            if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                goto success_structured;
                                                                                                                                                                            else
                                                                                                                                                                                goto structured;
                                                                                                                                                                            else
                                                                                                                                                                                goto structured;
                                                                                                                                                                            else
                                                                                                                                                                                if(p[_offset7] < threshold_bottom)
                                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                        else
                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                        else
                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                        else
                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                        else
                                                                                                                                                                                            goto structured;
                                                                                                                                                                                        else
                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                        else if(p[_offset0] < threshold_bottom)
                                                                                                                                                                                            if(p[_offset2] < threshold_bottom)
                                                                                                                                                                                                if(p[_offset7] > threshold_top)
                                                                                                                                                                                                    if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                                        if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                else
                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                else
                                                                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            goto structured;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            goto structured;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                    if(p[_offset5] > threshold_top)
                                                                                                                                                                                                                                        if(p[_offset3] > threshold_top)
                                                                                                                                                                                                                                            if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    if(p[_offset7] < threshold_bottom)
                                                                                                                                                                                                                                                        if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                            goto structured;
                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                            goto structured;
                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                goto success_structured;
                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                goto structured;
                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                    if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                                        if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                            if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                goto success_structured;
                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                goto structured;
                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                    goto success_structured;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    goto structured;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                                                                                                                                        if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                    if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                        if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                            if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                    if(p[_offset5] > threshold_top)
                                                                                                                                                                                                                                                                                                                                        if(p[_offset3] > threshold_top)
                                                                                                                                                                                                                                                                                                                                            if(p[_offset2] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                if(p[_offset1] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                        goto success_structured;
                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                        goto structured;
                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                            if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                goto success_structured;
                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                goto structured;
                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                goto structured;
                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                if(p[_offset7] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                            goto structured;
                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset7] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                            goto success_structured;
                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                goto success_structured;
                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                goto structured;
                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                goto structured;
                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                goto structured;
                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset3] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset5] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset2] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset1] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset7] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset4] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset6] > threshold_top)
                                                                                                                                                                                                                                                                                                                                                                                                                                        goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                        goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset3] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset5] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset2] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset1] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                            goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                                                            goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset7] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset6] < threshold_bottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto success_homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                goto homogeneous;
                }
            success_homogeneous:
                {
                    Feature feature;
                    feature.x() = (float)x;
                    feature.y() = (float)y;
                    features.push_back(feature);
                    goto homogeneous;
                }
            success_structured:
                {
                    Feature feature;
                    feature.x() = (float)x;
                    feature.y() = (float)y;
                    features.push_back(feature);
                    goto structured;
                }
            }
            p += numSkipPixels; // leave out 3 pixels of current line, plus 3 pixels of the next line
        }
        return features;
    }
    
    uint8_t AGASTDetection5_8::cornerScore(const int& x, const int& y)
    {
        int bmin = _threshold;
        int bmax = 255;
        int b_test = (bmax + bmin)/2;
        
        const uint8_t* p = &_image[y][x];
        
        while(1)
        {
            const int thresholdTop = *p + b_test;
            const int thresholdBottom = *p - b_test;
            if(p[_offset0] > thresholdTop)
                if(p[_offset2] > thresholdTop)
                    if(p[_offset3] > thresholdTop)
                        if(p[_offset5] > thresholdTop)
                            if(p[_offset1] > thresholdTop)
                                if(p[_offset4] > thresholdTop)
                                    goto is_a_corner;
                                else
                                    if(p[_offset7] > thresholdTop)
                                        goto is_a_corner;
                                    else
                                        goto is_not_a_corner;
                                    else
                                        if(p[_offset4] > thresholdTop)
                                            if(p[_offset6] > thresholdTop)
                                                goto is_a_corner;
                                            else
                                                goto is_not_a_corner;
                                            else
                                                goto is_not_a_corner;
                                            else
                                                if(p[_offset1] > thresholdTop)
                                                    if(p[_offset4] > thresholdTop)
                                                        goto is_a_corner;
                                                    else
                                                        if(p[_offset7] > thresholdTop)
                                                            goto is_a_corner;
                                                        else
                                                            goto is_not_a_corner;
                                                        else
                                                            goto is_not_a_corner;
                                                        else
                                                            if(p[_offset7] > thresholdTop)
                                                                if(p[_offset6] > thresholdTop)
                                                                    if(p[_offset5] > thresholdTop)
                                                                        if(p[_offset1] > thresholdTop)
                                                                            goto is_a_corner;
                                                                        else
                                                                            if(p[_offset4] > thresholdTop)
                                                                                goto is_a_corner;
                                                                            else
                                                                                goto is_not_a_corner;
                                                                            else
                                                                                if(p[_offset1] > thresholdTop)
                                                                                    goto is_a_corner;
                                                                                else
                                                                                    goto is_not_a_corner;
                                                                                else
                                                                                    goto is_not_a_corner;
                                                                                else
                                                                                    if(p[_offset5] < thresholdBottom)
                                                                                        if(p[_offset3] < thresholdBottom)
                                                                                            if(p[_offset7] < thresholdBottom)
                                                                                                if(p[_offset4] < thresholdBottom)
                                                                                                    if(p[_offset6] < thresholdBottom)
                                                                                                        goto is_a_corner;
                                                                                                    else
                                                                                                        goto is_not_a_corner;
                                                                                                    else
                                                                                                        goto is_not_a_corner;
                                                                                                    else
                                                                                                        goto is_not_a_corner;
                                                                                                    else
                                                                                                        goto is_not_a_corner;
                                                                                                    else
                                                                                                        goto is_not_a_corner;
                                                                                                    else
                                                                                                        if(p[_offset5] > thresholdTop)
                                                                                                            if(p[_offset7] > thresholdTop)
                                                                                                                if(p[_offset6] > thresholdTop)
                                                                                                                    if(p[_offset1] > thresholdTop)
                                                                                                                        goto is_a_corner;
                                                                                                                    else
                                                                                                                        if(p[_offset4] > thresholdTop)
                                                                                                                            goto is_a_corner;
                                                                                                                        else
                                                                                                                            goto is_not_a_corner;
                                                                                                                        else
                                                                                                                            goto is_not_a_corner;
                                                                                                                        else
                                                                                                                            goto is_not_a_corner;
                                                                                                                        else
                                                                                                                            if(p[_offset5] < thresholdBottom)
                                                                                                                                if(p[_offset3] < thresholdBottom)
                                                                                                                                    if(p[_offset2] < thresholdBottom)
                                                                                                                                        if(p[_offset1] < thresholdBottom)
                                                                                                                                            if(p[_offset4] < thresholdBottom)
                                                                                                                                                goto is_a_corner;
                                                                                                                                            else
                                                                                                                                                goto is_not_a_corner;
                                                                                                                                            else
                                                                                                                                                if(p[_offset4] < thresholdBottom)
                                                                                                                                                    if(p[_offset6] < thresholdBottom)
                                                                                                                                                        goto is_a_corner;
                                                                                                                                                    else
                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                    else
                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                    else
                                                                                                                                                        if(p[_offset7] < thresholdBottom)
                                                                                                                                                            if(p[_offset4] < thresholdBottom)
                                                                                                                                                                if(p[_offset6] < thresholdBottom)
                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                else
                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                else
                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                else
                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                else
                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                else
                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                else if(p[_offset0] < thresholdBottom)
                                                                                                                                                                    if(p[_offset2] < thresholdBottom)
                                                                                                                                                                        if(p[_offset7] > thresholdTop)
                                                                                                                                                                            if(p[_offset3] < thresholdBottom)
                                                                                                                                                                                if(p[_offset5] < thresholdBottom)
                                                                                                                                                                                    if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                        if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                        else
                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                        else
                                                                                                                                                                                            if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                if(p[_offset6] < thresholdBottom)
                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                else
                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                else
                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                else
                                                                                                                                                                                                    if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                        if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                        else
                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                        else
                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                        else
                                                                                                                                                                                                            if(p[_offset5] > thresholdTop)
                                                                                                                                                                                                                if(p[_offset3] > thresholdTop)
                                                                                                                                                                                                                    if(p[_offset4] > thresholdTop)
                                                                                                                                                                                                                        if(p[_offset6] > thresholdTop)
                                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                        else
                                                                                                                                                                                                                            if(p[_offset7] < thresholdBottom)
                                                                                                                                                                                                                                if(p[_offset3] < thresholdBottom)
                                                                                                                                                                                                                                    if(p[_offset5] < thresholdBottom)
                                                                                                                                                                                                                                        if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                            if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                if(p[_offset6] < thresholdBottom)
                                                                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                    if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                                        goto is_a_corner;
                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                        if(p[_offset6] < thresholdBottom)
                                                                                                                                                                                                                                                            if(p[_offset5] < thresholdBottom)
                                                                                                                                                                                                                                                                if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                    if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                        goto is_a_corner;
                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                        if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                            if(p[_offset3] < thresholdBottom)
                                                                                                                                                                                                                                                                                if(p[_offset5] < thresholdBottom)
                                                                                                                                                                                                                                                                                    if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                                                                        if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                            if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                                                if(p[_offset6] < thresholdBottom)
                                                                                                                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                    if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                                                                                        if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                            if(p[_offset5] > thresholdTop)
                                                                                                                                                                                                                                                                                                                if(p[_offset3] > thresholdTop)
                                                                                                                                                                                                                                                                                                                    if(p[_offset2] > thresholdTop)
                                                                                                                                                                                                                                                                                                                        if(p[_offset1] > thresholdTop)
                                                                                                                                                                                                                                                                                                                            if(p[_offset4] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                goto is_a_corner;
                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                if(p[_offset4] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                    if(p[_offset6] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                        goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                        if(p[_offset7] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                            if(p[_offset4] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                if(p[_offset6] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                    if(p[_offset5] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                        if(p[_offset7] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                            if(p[_offset6] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                        goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset3] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset5] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset2] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset1] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset4] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset6] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset7] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset4] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset6] > thresholdTop)
                                                                                                                                                                                                                                                                                                                                                                                                                goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                            else
                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset3] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset5] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset2] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset1] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                    goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                    goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                else
                                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                        if(p[_offset6] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                            goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                                            goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                                                                                                                                                                                            if(p[_offset7] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                if(p[_offset4] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if(p[_offset6] < thresholdBottom)
                                                                                                                                                                                                                                                                                                                                                                                                                                                        goto is_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    else
                                                                                                                                                                                                                                                                                                                                                                                                                                                        goto is_not_a_corner;
        is_a_corner:
            bmin=b_test;
            goto end;
            
        is_not_a_corner:
            bmax=b_test;
            goto end;
            
        end:
            
            if(bmin == bmax - 1 || bmin == bmax)
                return bmin;
            b_test = (bmin + bmax) / 2;
        }
    }
}


